<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Analytics Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains configuration options for analytics tracking,
    | reporting, and data retention for the trust seal portal.
    |
    */

    /*
    |--------------------------------------------------------------------------
    | General Settings
    |--------------------------------------------------------------------------
    */

    'enabled' => env('ANALYTICS_ENABLED', true),
    'debug' => env('ANALYTICS_DEBUG', false),
    'queue_connection' => env('ANALYTICS_QUEUE_CONNECTION', 'redis'),
    'queue_name' => env('ANALYTICS_QUEUE_NAME', 'analytics'),

    /*
    |--------------------------------------------------------------------------
    | Data Collection
    |--------------------------------------------------------------------------
    */

    'collection' => [
        'trust_seals' => [
            'views' => true,
            'clicks' => true,
            'interactions' => true,
            'load_times' => true,
            'errors' => true,
        ],
        'domains' => [
            'verification_events' => true,
            'security_checks' => true,
            'ssl_status' => true,
            'uptime' => true,
        ],
        'users' => [
            'page_views' => true,
            'session_duration' => true,
            'feature_usage' => true,
            'conversion_events' => true,
        ],
        'geographic' => [
            'enabled' => env('ANALYTICS_GEO_ENABLED', true),
            'provider' => env('ANALYTICS_GEO_PROVIDER', 'maxmind'), // maxmind, ipinfo, geojs
            'precision' => 'city', // country, region, city
            'anonymize' => true,
        ],
        'user_agent' => [
            'enabled' => true,
            'parse_browser' => true,
            'parse_os' => true,
            'parse_device' => true,
            'bot_detection' => true,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Data Retention
    |--------------------------------------------------------------------------
    */

    'retention' => [
        'raw_events' => [
            'days' => env('ANALYTICS_RAW_RETENTION_DAYS', 90),
            'cleanup_frequency' => 'daily',
        ],
        'aggregated_data' => [
            'hourly' => env('ANALYTICS_HOURLY_RETENTION_DAYS', 30),
            'daily' => env('ANALYTICS_DAILY_RETENTION_DAYS', 365),
            'monthly' => env('ANALYTICS_MONTHLY_RETENTION_DAYS', 1095), // 3 years
            'yearly' => env('ANALYTICS_YEARLY_RETENTION_DAYS', -1), // unlimited
        ],
        'user_sessions' => [
            'days' => env('ANALYTICS_SESSION_RETENTION_DAYS', 30),
        ],
        'exports' => [
            'days' => env('ANALYTICS_EXPORT_RETENTION_DAYS', 7),
            'max_file_size_mb' => 100,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Real-time Analytics
    |--------------------------------------------------------------------------
    */

    'real_time' => [
        'enabled' => env('ANALYTICS_REALTIME_ENABLED', true),
        'update_interval' => env('ANALYTICS_REALTIME_INTERVAL', 5), // seconds
        'batch_size' => env('ANALYTICS_REALTIME_BATCH_SIZE', 100),
        'channels' => [
            'trust_seal_views' => true,
            'security_alerts' => true,
            'domain_verifications' => true,
            'user_activity' => true,
        ],
        'cache' => [
            'driver' => env('ANALYTICS_CACHE_DRIVER', 'redis'),
            'ttl' => env('ANALYTICS_CACHE_TTL', 300), // 5 minutes
            'prefix' => 'analytics:realtime:',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Reporting
    |--------------------------------------------------------------------------
    */

    'reporting' => [
        'default_timezone' => env('ANALYTICS_TIMEZONE', 'UTC'),
        'date_formats' => [
            'display' => 'M j, Y',
            'api' => 'Y-m-d',
            'export' => 'Y-m-d H:i:s',
        ],
        'charts' => [
            'default_period' => '30d', // 1d, 7d, 30d, 90d, 1y
            'max_data_points' => 365,
            'colors' => [
                'primary' => '#007bff',
                'success' => '#28a745',
                'warning' => '#ffc107',
                'danger' => '#dc3545',
                'info' => '#17a2b8',
            ],
        ],
        'exports' => [
            'formats' => ['csv', 'json', 'pdf'],
            'max_rows' => 10000,
            'queue_large_exports' => true,
            'large_export_threshold' => 1000,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Aggregation Settings
    |--------------------------------------------------------------------------
    */

    'aggregation' => [
        'schedule' => [
            'hourly' => '0 * * * *',
            'daily' => '0 1 * * *',
            'weekly' => '0 2 * * 0',
            'monthly' => '0 3 1 * *',
        ],
        'batch_size' => 1000,
        'timeout' => 300, // seconds
        'metrics' => [
            'views' => [
                'total_count',
                'unique_count',
                'bounce_rate',
                'average_duration',
            ],
            'geographic' => [
                'top_countries',
                'top_cities',
                'country_distribution',
            ],
            'devices' => [
                'browser_distribution',
                'os_distribution',
                'device_type_distribution',
            ],
            'performance' => [
                'average_load_time',
                'error_rate',
                'availability',
            ],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Privacy and Compliance
    |--------------------------------------------------------------------------
    */

    'privacy' => [
        'anonymize_ip' => env('ANALYTICS_ANONYMIZE_IP', true),
        'respect_dnt' => env('ANALYTICS_RESPECT_DNT', true), // Do Not Track
        'gdpr_compliant' => env('ANALYTICS_GDPR_COMPLIANT', true),
        'ccpa_compliant' => env('ANALYTICS_CCPA_COMPLIANT', true),
        'consent_required' => env('ANALYTICS_CONSENT_REQUIRED', false),
        'data_deletion' => [
            'enabled' => true,
            'retention_after_request' => 30, // days
        ],
        'excluded_ips' => [
            '127.0.0.1',
            '::1',
            // Add internal IPs to exclude from analytics
        ],
        'bot_filtering' => [
            'enabled' => true,
            'patterns' => [
                'googlebot',
                'bingbot',
                'slurp',
                'duckduckbot',
                'baiduspider',
                'yandexbot',
                'facebookexternalhit',
                'twitterbot',
                'linkedinbot',
                'whatsapp',
                'telegram',
            ],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | External Integrations
    |--------------------------------------------------------------------------
    */

    'integrations' => [
        'google_analytics' => [
            'enabled' => env('GA_ENABLED', false),
            'tracking_id' => env('GA_TRACKING_ID'),
            'property_id' => env('GA_PROPERTY_ID'),
            'api_secret' => env('GA_API_SECRET'),
            'sync_events' => true,
        ],
        'mixpanel' => [
            'enabled' => env('MIXPANEL_ENABLED', false),
            'token' => env('MIXPANEL_TOKEN'),
            'sync_events' => false,
        ],
        'amplitude' => [
            'enabled' => env('AMPLITUDE_ENABLED', false),
            'api_key' => env('AMPLITUDE_API_KEY'),
            'sync_events' => false,
        ],
        'custom_webhooks' => [
            'enabled' => env('ANALYTICS_WEBHOOKS_ENABLED', false),
            'endpoints' => [
                // 'https://your-webhook-endpoint.com/analytics'
            ],
            'events' => [
                'trust_seal_viewed',
                'domain_verified',
                'security_alert',
            ],
            'retry_attempts' => 3,
            'timeout' => 10,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Performance Monitoring
    |--------------------------------------------------------------------------
    */

    'performance' => [
        'track_queries' => env('ANALYTICS_TRACK_QUERIES', false),
        'slow_query_threshold' => 1000, // milliseconds
        'track_memory_usage' => env('ANALYTICS_TRACK_MEMORY', false),
        'track_cache_hits' => env('ANALYTICS_TRACK_CACHE', false),
        'alert_thresholds' => [
            'high_load_time' => 5000, // milliseconds
            'high_error_rate' => 5, // percentage
            'low_availability' => 95, // percentage
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | API Settings
    |--------------------------------------------------------------------------
    */

    'api' => [
        'rate_limits' => [
            'events' => 1000, // per minute
            'queries' => 100, // per minute
            'exports' => 10, // per hour
        ],
        'authentication' => [
            'required' => true,
            'api_key_header' => 'X-Analytics-API-Key',
        ],
        'pagination' => [
            'default_per_page' => 50,
            'max_per_page' => 1000,
        ],
        'caching' => [
            'enabled' => true,
            'ttl' => 300, // 5 minutes
            'cache_key_prefix' => 'analytics:api:',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Alerting
    |--------------------------------------------------------------------------
    */

    'alerts' => [
        'enabled' => env('ANALYTICS_ALERTS_ENABLED', true),
        'channels' => ['mail', 'slack', 'webhook'],
        'thresholds' => [
            'traffic_spike' => [
                'enabled' => true,
                'multiplier' => 5, // 5x normal traffic
                'time_window' => 15, // minutes
            ],
            'traffic_drop' => [
                'enabled' => true,
                'percentage' => 50, // 50% drop
                'time_window' => 30, // minutes
            ],
            'error_rate' => [
                'enabled' => true,
                'percentage' => 10, // 10% error rate
                'time_window' => 10, // minutes
            ],
            'load_time' => [
                'enabled' => true,
                'threshold' => 5000, // 5 seconds
                'time_window' => 15, // minutes
            ],
        ],
        'cooldown' => 3600, // 1 hour between same alerts
    ],

];