<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('domains', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('domain', 255)->unique();
            $table->string('status')->default('pending'); // pending, verified, suspended
            $table->timestamp('verified_at')->nullable();
            $table->json('verification_methods')->nullable(); // dns, file, meta
            $table->string('verification_token', 64)->unique();
            $table->json('ssl_info')->nullable();
            $table->integer('security_score')->default(0);
            $table->timestamp('last_security_check')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->index(['user_id', 'status']);
            $table->index('domain');
        });
    }

    public function down()
    {
        Schema::dropIfExists('domains');
    }
};