<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('domain_verifications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('domain_id')->constrained()->onDelete('cascade');
            $table->enum('method', ['dns', 'file', 'meta']);
            $table->string('token', 64);
            $table->string('expected_value', 500);
            $table->string('found_value', 500)->nullable();
            $table->enum('status', ['pending', 'verified', 'failed', 'expired'])->default('pending');
            $table->text('error_message')->nullable();
            $table->timestamp('verified_at')->nullable();
            $table->timestamp('expires_at');
            $table->integer('attempts')->default(0);
            $table->timestamp('last_attempt_at')->nullable();
            $table->timestamps();
            
            $table->index(['domain_id', 'method']);
            $table->index(['status', 'expires_at']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('domain_verifications');
    }
};