<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('seal_analytics', function (Blueprint $table) {
            $table->id();
            $table->foreignId('trust_seal_id')->constrained()->onDelete('cascade');
            $table->string('ip_address', 45);
            $table->string('user_agent', 500)->nullable();
            $table->string('referrer', 500)->nullable();
            $table->string('country_code', 2)->nullable();
            $table->string('city', 100)->nullable();
            $table->string('browser', 50)->nullable();
            $table->string('os', 50)->nullable();
            $table->string('device_type', 20)->nullable(); // desktop, mobile, tablet
            $table->timestamp('viewed_at');
            $table->timestamps();
            
            $table->index(['trust_seal_id', 'viewed_at']);
            $table->index(['viewed_at', 'country_code']);
            $table->index('ip_address');
        });
    }

    public function down()
    {
        Schema::dropIfExists('seal_analytics');
    }
};