<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('phone')->nullable()->after('email');
            $table->string('company')->nullable()->after('phone');
            $table->string('website')->nullable()->after('company');
            $table->enum('account_type', ['individual', 'business'])->default('individual')->after('website');
            $table->boolean('is_premium')->default(false)->after('account_type');
            $table->timestamp('premium_expires_at')->nullable()->after('is_premium');
            $table->json('preferences')->nullable()->after('premium_expires_at');
            $table->boolean('email_notifications')->default(true)->after('preferences');
            $table->boolean('security_alerts')->default(true)->after('email_notifications');
            $table->timestamp('last_login_at')->nullable()->after('security_alerts');
            $table->string('last_login_ip')->nullable()->after('last_login_at');
        });
    }

    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'phone', 'company', 'website', 'account_type', 'is_premium',
                'premium_expires_at', 'preferences', 'email_notifications',
                'security_alerts', 'last_login_at', 'last_login_ip'
            ]);
        });
    }
};